import pygame
from pygame import *
from sprites import Snake
from sprites import Food
from maps import map1
import random

pygame.init()

DEFAULT_SCREEN_SIZE = [640, 480]
INITIAL_DIRECTION = Snake.SnakeMove.RIGHT
DEFAULT_UPDATE_SPEED = 200

updatetime = pygame.time.get_ticks() + DEFAULT_UPDATE_SPEED

#screen initialization
screen = pygame.display.set_mode(DEFAULT_SCREEN_SIZE)
display.set_caption('Cat Chase')

#sprite initialization
snake, food = Snake(None), None
is_done, is_over, is_paused = False, False, False
direction, score, game_map = None, 0, map1

def render_background():
    global game_map
    #loops through map to set background
    for y in range(len(game_map.MAP)):
        for x in range(len(game_map.MAP[y])):
            location = (x*32, y*32)
            screen.blit(game_map.SOURCE, location, game_map.MAP[y][x])

#renders the snake on screen
def render_snake():
    screen.blit(snake.head.image, snake.head.rect)
    for count in range(len(snake.tail.tiles)):
        screen.blit(snake.tail.tiles[count]['image'], snake.tail.tiles[count]['rect'])

#creates a new food
def create_food():
    global food, snake

    hlimit = (DEFAULT_SCREEN_SIZE[0]/Food._DEFAULT_SIZE[0])-1
    vlimit = (DEFAULT_SCREEN_SIZE[1]/Food._DEFAULT_SIZE[1])-1
    X, Y = None, None

    while snake.occupies_position([X, Y]) or overlaps_barrier([X, Y]):
        X = random.randint(0, hlimit)*Food._DEFAULT_SIZE[0]
        Y = random.randint(0, vlimit)*Food._DEFAULT_SIZE[1]
    food = Food([X, Y])

def overlaps_barrier(pos):
    global game_map
    try:
        idx = game_map.barriers.index(pos)
        return True
    except:
        return False

#renders the food on screen on refresh
def render_food():
    global food
    screen.blit(food.image, food.rect)

def process_action():
    global is_done, direction, is_paused
    for e in event.get():
        if e.type == KEYUP:
            if e.key == K_ESCAPE:
                is_done = True
            elif e.key == K_UP and direction != Snake.SnakeMove.DOWN:
                direction = Snake.SnakeMove.UP
            elif e.key == K_DOWN and  direction != Snake.SnakeMove.UP:
                direction = Snake.SnakeMove.DOWN
            elif e.key == K_RIGHT and direction != Snake.SnakeMove.LEFT:
                direction = Snake.SnakeMove.RIGHT
            elif e.key == K_LEFT and direction != Snake.SnakeMove.RIGHT:
                direction = Snake.SnakeMove.LEFT
            elif e.key == K_RETURN:
                reset_game()
            elif e.key == K_SPACE and not is_over:
                is_paused = not is_paused

def update_display():
    global is_over, direction, score, snake, food, updatetime, game_map
    currenttime = pygame.time.get_ticks()
        
    if not is_over:
        if currenttime >= updatetime:
            moved = snake.move(direction, DEFAULT_SCREEN_SIZE[0], DEFAULT_SCREEN_SIZE[1], game_map.barriers)
            is_over = True if not moved else False
                
            if snake.occupies_position(food.rect.topleft):
                create_food()
                snake.lengthen_tail()
                score += 1
                display.set_caption('Cats Chased: ' + str(score))

            render_food()
            render_snake()

            pygame.display.update()
            updatetime =  currenttime + DEFAULT_UPDATE_SPEED
    else:
        display.set_caption('Cats Chased: ' + str(score) + ' GAME OVER - Hit Enter to restart game.')

def start_game():
    global is_done, direction, is_paused
    create_food()

    while not is_done:
        render_background()
        
        if direction == None:
            direction = INITIAL_DIRECTION

        #checks for changes in direction and validates it
        process_action()

        if is_paused:
            continue;

        #updates the display
        update_display()

def reset_game():
    global snake, food, is_over, direction, score
    
    display.set_caption('Cat Chase')
    snake, food, is_over, direction, score = Snake(None), None, False, INITIAL_DIRECTION, 0
    create_food()

start_game()